
local assets =
{
    Asset("ANIM", "anim/scrap.zip"),
	
    Asset("ATLAS", "images/inventoryimages/scrap.xml"),
    Asset("IMAGE", "images/inventoryimages/scrap.tex"),
}

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
	
	if IsDLCEnabled(CAPY_DLC) then
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end

    inst.AnimState:SetBank("scrap")
    inst.AnimState:SetBuild("scrap")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("molebait")
    inst:AddComponent("inspectable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "scrap"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/scrap.xml"

    return inst
end

return Prefab("common/inventory/scrap", fn, assets)